/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.axis.components.uuid.UUIDGen;

public class WSFastUUIDGen
implements UUIDGen {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    protected String m_className = "WSFastUUIDGen";
    private static long lastSeed = 0L;
    private Random secureRandom;
    private String nodeStr;
    private int clockSequence;
    private long lastTime = 0L;
    private static String prevUUID = null;

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 21:01:20  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }

    private String getNodeHexValue() {
        long node = 0L;
        long nodeValue = 0L;
        while ((node = WSFastUUIDGen.getBitsValue(nodeValue, 47, 47)) == 0L) {
            nodeValue = this.secureRandom.nextLong();
        }
        return WSFastUUIDGen.leftZeroPadString(Long.toHexString(node |= 0x800000000000L), 12);
    }

    private int getClockSequence() {
        return this.secureRandom.nextInt(16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSFastUUIDGen() {
        String m_method = "Ctor";
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            try {
                this.secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
            }
            catch (Exception e) {
                this.secureRandom = new Random();
            }
            long seed = System.currentTimeMillis() + (long)System.identityHashCode(this);
            if (seed == lastSeed) {
                lastSeed = seed += System.currentTimeMillis();
            }
            if (logger.isFinest()) {
                logger.finest(this.m_className, m_method, "Seeding secureRandom object with " + seed);
            }
            this.secureRandom.setSeed(seed);
            this.nodeStr = this.getNodeHexValue();
            this.clockSequence = this.getClockSequence();
        }
    }

    public synchronized String nextUUID() {
        String uuidStr = null;
        do {
            uuidStr = this.getNextUUID();
        } while (prevUUID != null && prevUUID.compareTo(uuidStr) == 0);
        prevUUID = uuidStr;
        return uuidStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextUUID() {
        long time = System.currentTimeMillis();
        long timestamp = time * 10000L;
        timestamp += 122192927672762368L;
        timestamp += 327237632L;
        WSFastUUIDGen wSFastUUIDGen = this;
        synchronized (wSFastUUIDGen) {
            if (time - this.lastTime <= 0L) {
                this.clockSequence = this.clockSequence + 1 & 0x3FFF;
            }
            this.lastTime = time;
        }
        long timeLow = WSFastUUIDGen.getBitsValue(timestamp, 32, 32);
        long timeMid = WSFastUUIDGen.getBitsValue(timestamp, 48, 16);
        long timeHi = WSFastUUIDGen.getBitsValue(timestamp, 64, 16) | 0x1000L;
        long clockSeqLow = WSFastUUIDGen.getBitsValue(this.clockSequence, 8, 8);
        long clockSeqHi = WSFastUUIDGen.getBitsValue(this.clockSequence, 16, 8) | 0x80L;
        String timeLowStr = WSFastUUIDGen.leftZeroPadString(Long.toHexString(timeLow), 8);
        String timeMidStr = WSFastUUIDGen.leftZeroPadString(Long.toHexString(timeMid), 4);
        String timeHiStr = WSFastUUIDGen.leftZeroPadString(Long.toHexString(timeHi), 4);
        String clockSeqHiStr = WSFastUUIDGen.leftZeroPadString(Long.toHexString(clockSeqHi), 2);
        String clockSeqLowStr = WSFastUUIDGen.leftZeroPadString(Long.toHexString(clockSeqLow), 2);
        StringBuffer result = new StringBuffer(36);
        result.append(timeLowStr).append("-");
        result.append(timeMidStr).append("-");
        result.append(timeHiStr).append("-");
        result.append(clockSeqHiStr).append(clockSeqLowStr);
        result.append("-").append(this.nodeStr);
        return result.toString();
    }

    private static long getBitsValue(long value, int startBit, int bitLen) {
        return value << 64 - startBit >>> 64 - bitLen;
    }

    private static final String leftZeroPadString(String bitString, int len) {
        if (bitString.length() < len) {
            int nbExtraZeros = len - bitString.length();
            StringBuffer extraZeros = new StringBuffer();
            for (int i = 0; i < nbExtraZeros; ++i) {
                extraZeros.append("0");
            }
            extraZeros.append(bitString);
            bitString = extraZeros.toString();
        }
        return bitString;
    }
}

